// $Id: CModulatedXYPad.cpp,v 1.6 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CModulatedXYPad.hpp"
using Exponent::GUI::Controls::CModulatedXYPad;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CModulatedXYPad, CXYPad);

//	===========================================================================
CModulatedXYPad::CModulatedXYPad(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener) 
			   : CXYPad(root, uniqueId, area, listener)
			   , m_modulationHandle(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CModulatedXYPad);
	m_modulationHandlePosition = m_handleArea;
}

//	===========================================================================
CModulatedXYPad::~CModulatedXYPad()
{
	EXPONENT_CLASS_DESTRUCTION(CModulatedXYPad);
	FORGET_COUNTED_OBJECT(m_modulationHandle);
}

//	===========================================================================
void CModulatedXYPad::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	// Draw the background
	this->drawPrimaryImage(graphics, m_doDefaultDrawing);

	// Now draw the modulation paddle
	if (m_modulationHandle)
	{
		graphics.drawImage(m_modulationHandle, m_modulationHandlePosition, m_modulationHandle->getNormalisedImageSize());
	}
	else
	{
		graphics.getMutableBrush()->setColour(CAlphaColour::CALPHACOLOUR_PINK);
		graphics.fillRectangle(m_modulationHandlePosition);
		graphics.drawRectangle(m_modulationHandlePosition);
	}

	// Now draw the hnadle
	graphics.getMutablePen()->setColour(CAlphaColour::CALPHACOLOUR_BLACK);
	IImage *theImage = NULL;
	CAlphaColour theColour;
	switch(m_state)
	{
		case CRolloverButton::e_mouseOff:
			if (m_handleImage)
			{
				theImage = m_handleImage;
			}
			else
			{
				theImage  = NULL;
				theColour = m_handleColour;
			}
		break;
		case CRolloverButton::e_mouseOver:
			if (m_handleRolloverImage)
			{
				theImage = m_handleRolloverImage;
			}
			else if (m_handleImage)
			{
				theImage = m_handleImage;
			}
			else
			{
				theImage  = NULL;
				theColour = m_handleOverColour;
			}
		break;
		case CRolloverButton::e_mouseDown:
			if (m_handleDownImage)
			{
				theImage = m_handleDownImage;
			}
			else if (m_handleImage)
			{
				theImage = m_handleImage;
			}
			else
			{
				theImage  = NULL;
				theColour = m_handleDownColour;
			}
		break;
	}
	if (theImage)
	{
		graphics.drawImage(theImage, m_handleArea, theImage->getNormalisedImageSize());
	}
	else
	{
		graphics.getMutableBrush()->setColour(theColour);
		graphics.fillRectangle(m_handleArea);
		graphics.drawRectangle(m_handleArea);
	}
}

//	===========================================================================
void CModulatedXYPad::setXValue(const double xValue)
{
	m_modulationHandlePosition.setLeft((long)(xValue * m_horizontalRange));
	CXYPad::setXValue(xValue);
}

//	===========================================================================
void CModulatedXYPad::setYValue(const double yValue)
{
	m_modulationHandlePosition.setTop((long)((1.0 - yValue) * m_verticalRange));
	CXYPad::setYValue(yValue);
}

//	===========================================================================
void CModulatedXYPad::setModulationPosition(const double xValue, const double yValue)
{
	m_modulationHandlePosition.setLeft((long)(xValue * m_horizontalRange));
	m_modulationHandlePosition.setTop((long)((1.0 - yValue) * m_verticalRange));
	this->update();
}